/**
*    Wave.cpp
*    
*    Extention of Routine to display a Wave effect using the sin function.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "Wave.h"

Wave::Wave()
{
	runTime = 0;
}

void Wave::update(unsigned long dt)
{
	runTime += 1.0*dt/1000000;

	for(byte x = 0 ; x < CUBE_SIZE ; x++)
	{
		for(byte y = 0 ; y < CUBE_SIZE ; y++)
		{
			for(byte z = 0 ; z < CUBE_SIZE ; z++)
			{
				cubeModel[x][y][z] = false;	
			}
		}
	}	
	for(byte x = 0 ; x < CUBE_SIZE ; x++)
	{
		for(byte y = 0 ; y < CUBE_SIZE ; y++)
		{			
			float zfloat = 1.5*sin(.75*(x-3) + 5*runTime) + 1.5*cos(.75*(y-3) + 5*runTime) + 3;
			int z = int(zfloat + .5);
		
			cubeModel[x][y][z] = true;
		}		
	}		
}

/**
float Wave::fastSin(double x)
{
	x = (int(100*x) % 628)*1.0/100;
	if(x > 4.71)
	{
		x-=6.28;
	}
	else if(x > 1.57)
	{
		x = 3.14-x;
	}
	return (x - x*x*x/6);
}

float Wave::fastCos(double x)
{
	return fastSin(x + 1.57);
}
**/